/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entites;

import com.finallion.graveyard.entites.AnimatedGraveyardEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class BaseGhoulEntity
extends AnimatedGraveyardEntity
implements IAnimatable {
    private final AnimationBuilder DEATH_ANIMATION = new AnimationBuilder().addAnimation("death", Boolean.valueOf(false));
    private final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true));
    private final AnimationBuilder WALK_ANIMATION = new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true));
    private final AnimationBuilder RAGE_ANIMATION = new AnimationBuilder().addAnimation("rage", Boolean.valueOf(false));
    private final AnimationBuilder RUNNING_ANIMATION = new AnimationBuilder().addAnimation("running", Boolean.valueOf(true));
    private final AnimationBuilder ATTACK_ANIMATION = new AnimationBuilder().addAnimation("attack", Boolean.valueOf(true));
    protected static final byte ANIMATION_IDLE = 0;
    protected static final byte ANIMATION_WALK = 1;
    protected static final byte ANIMATION_RAGE = 2;
    protected static final byte ANIMATION_DEATH = 3;
    protected static final byte ANIMATION_RUNNING = 4;
    protected static final byte ANIMATION_ATTACK = 5;
    protected static final DataParameter<Byte> VARIANT = EntityDataManager.func_187226_a(BaseGhoulEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static boolean isInRange = false;
    private static final double ATTACK_RANGE = 2.0;
    private EntityPredicate targetPredicate = new EntityPredicate().func_221013_a(25.0).func_221014_c();

    public BaseGhoulEntity(EntityType<? extends BaseGhoulEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        byte variant = (byte)this.field_70146_Z.nextInt(8);
        this.field_70180_af.func_187214_a(VARIANT, (Object)variant);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new GhoulMeleeAttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{BaseGhoulEntity.class}));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.195).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233826_i_, 3.0).func_233815_a_(Attributes.field_233820_c_, 0.5);
    }

    public static boolean isDarkEnoughToSpawn(IServerWorld p_223323_0_, BlockPos p_223323_1_, Random p_223323_2_) {
        if (p_223323_0_.func_226658_a_(LightType.SKY, p_223323_1_) > p_223323_2_.nextInt(32)) {
            return false;
        }
        int i = p_223323_0_.func_201672_e().func_72911_I() ? p_223323_0_.func_205049_d(p_223323_1_, 10) : p_223323_0_.func_201696_r(p_223323_1_);
        return i <= p_223323_2_.nextInt(8);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends AnimatedGraveyardEntity> p_223325_0_, IServerWorld p_223325_1_, SpawnReason p_223325_2_, BlockPos p_223325_3_, Random p_223325_4_) {
        return p_223325_1_.func_175659_aa() != Difficulty.PEACEFUL && BaseGhoulEntity.isDarkEnoughToSpawn(p_223325_1_, p_223325_3_, p_223325_4_) && BaseGhoulEntity.func_223315_a(p_223325_0_, (IWorld)p_223325_1_, (SpawnReason)p_223325_2_, (BlockPos)p_223325_3_, (Random)p_223325_4_);
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74774_a("ghoulVariant", this.getVariant());
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setVariant(tag.func_74771_c("ghoulVariant"));
    }

    private void isInAttackDistance() {
        if (this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) > 4.5) {
            isInRange = false;
            this.setState((byte)2);
        }
    }

    private boolean isInRageDistance() {
        AxisAlignedBB box = new AxisAlignedBB(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_())).func_72314_b(15.0, 5.0, 15.0);
        PlayerEntity player = this.field_70170_p.func_217370_a(this.targetPredicate, (LivingEntity)this);
        LivingEntity villager = this.field_70170_p.func_225318_b(AbstractVillagerEntity.class, this.targetPredicate, (LivingEntity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), box);
        LivingEntity ironGolem = this.field_70170_p.func_225318_b(IronGolemEntity.class, this.targetPredicate, (LivingEntity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), box);
        if (player != null) {
            return !((double)this.func_70032_d((Entity)player) < 4.5);
        }
        if (villager != null) {
            return !((double)this.func_70032_d((Entity)villager) < 4.5);
        }
        if (ironGolem != null) {
            return !((double)this.func_70032_d((Entity)ironGolem) < 4.5);
        }
        return true;
    }

    private void stopAttackAnimation() {
        if (!this.isCreepy()) {
            this.setState((byte)2);
        }
    }

    @Override
    public void func_70636_d() {
        this.isInAttackDistance();
        this.stopAttackAnimation();
        super.func_70636_d();
    }

    private <E extends IAnimatable> PlayState predicate2(AnimationEvent<E> event) {
        if ((Byte)this.field_70180_af.func_187225_a(ANIMATION_MOVE_STATE) == 5 && !this.func_233643_dh_() && !((double)this.func_110143_aJ() < 0.01) && isInRange) {
            event.getController().setAnimation(this.ATTACK_ANIMATION);
            return PlayState.CONTINUE;
        }
        if ((Byte)this.field_70180_af.func_187225_a(ANIMATION_MOVE_STATE) == 2 && !this.func_233643_dh_() && !((double)this.func_110143_aJ() < 0.01) && this.isInRageDistance() && (Byte)this.field_70180_af.func_187225_a(ANIMATION_MOVE_STATE) != 1) {
            event.getController().setAnimation(this.RAGE_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        boolean isMoving;
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean bl = isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        if (this.func_233643_dh_()) {
            event.getController().setAnimation(this.DEATH_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (event.isMoving() || isMoving) {
            if (this.func_70090_H()) {
                event.getController().setAnimation(this.WALK_ANIMATION);
            } else if (this.func_213398_dR()) {
                event.getController().setAnimation(this.RUNNING_ANIMATION);
            } else {
                event.getController().setAnimation(this.WALK_ANIMATION);
            }
        } else {
            event.getController().setAnimation(this.IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public byte getVariant() {
        return (Byte)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(byte variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller2", 0.0f, this::predicate2));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void func_70642_aH() {
        this.func_184185_a(SoundEvents.field_190022_cI, 1.0f, -5.0f);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        this.func_184185_a(SoundEvents.field_190024_cK, 1.0f, -5.0f);
        return super.func_184601_bQ(p_184601_1_);
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        this.func_184185_a(SoundEvents.field_190023_cJ, 1.0f, -5.0f);
        return super.func_184615_bR();
    }

    static class GhoulMeleeAttackGoal
    extends MeleeAttackGoal {
        private final BaseGhoulEntity ghoul;
        private static final int ATTACK_DURATION = 7;
        private int attackTimer = 0;

        public GhoulMeleeAttackGoal(BaseGhoulEntity ghoulEntity, double speed, boolean pauseWhenIdle) {
            super((CreatureEntity)ghoulEntity, speed, pauseWhenIdle);
            this.ghoul = ghoulEntity;
        }

        public void func_75246_d() {
            LivingEntity livingEntity = this.field_75441_b.func_70638_az();
            isInRange = false;
            if (livingEntity != null) {
                double squaredDistance = this.field_75441_b.func_70092_e(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_());
                isInRange = squaredDistance < 2.0;
            }
            super.func_75246_d();
        }

        protected void func_190102_a(LivingEntity target, double squaredDistance) {
            if (squaredDistance <= 2.0 && this.attackTimer <= 0) {
                this.ghoul.setState((byte)5);
                this.attackTimer = 7;
                this.field_75441_b.func_70652_k((Entity)target);
                --this.attackTimer;
            }
            if (this.attackTimer > 0) {
                --this.attackTimer;
                if (this.attackTimer == 0) {
                    this.ghoul.setState((byte)4);
                }
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.attackTimer = 0;
        }
    }
}

